
Type TFixedRevoluteJoint Extends TJoint

	'#Region private members
	Field _body:TBody
	
	Field _biasfactor:Float =.8
	Field _softness:Float = 0
	Field _breakpoint:Float = MathHelper.MaxValueF
	Field _maxImpulse:Float = MathHelper.MaxValueF
	
	Field _jointError:Float
	Field _localAnchor:Vector2 = Vector2.Zero()
	Field _anchor:Vector2 = Vector2.Zero()
	Field _r1:Vector2 = Vector2.Zero()
	Field _matrix:TMatrix = TMatrix.Identity()
	Field _velocityBias:Vector2 = Vector2.Zero()
	Field _accumulatedImpulse:Vector2 = Vector2.Zero()
	'#End Region 
		
	'#Region Properties (setter/getter)
	Method GetBody:TBody()
		Return _body
	End Method
	
	Method SetBody(value:TBody)
		_body = value
	End Method
	
	Method GetSoftness:Float()
		Return _softness
	End Method
	
	Method SetSoftness(value:Float)
		_softness = value
	End Method
	
	Method GetBreakPoint:Float()
		Return _breakpoint
	End Method
	
	Method SetBreakPoint(value:Float)
		_breakpoint = value
	End Method
	
	Method GetMaxImpulse:Float()
		Return _maxImpulse
	End Method
	
	Method SetMaxImpulse(value:Float)
		_maxImpulse = value
	End Method
	
	Method GetJointError:Float()
		Return _jointError
	End Method
	
	Method SetAnchor(value:Vector2)
		_anchor.X = value.X
		_anchor.Y = value.Y
		_SetAnchor(_anchor)
	End Method
	
	Method GetAnchor:Vector2()
		Return _anchor.Copy()
	End Method
	
	Method _SetAnchor(anchor:Vector2)
		_anchor.X = anchor.X
		_anchor.Y = anchor.Y
		If _body = Null Then Throw "Body must be set prior to setting the anchor of the revolute joint"
		_body.GetLocalPositionRef(anchor, _localAnchor)
	End Method
	'#End Region 
	
	'#Region Construction
	Function Create:TFixedRevoluteJoint(body:TBody, anchor:Vector2)
		Local joint:TFixedRevoluteJoint = New TFixedRevoluteJoint
		joint._body = body
		joint._anchor.X = anchor.X
		joint._anchor.Y = anchor.Y
		body.GetLocalPositionRef(anchor, joint._localAnchor)
		Return joint
	End Function
	
	'#End Region 
	
	
	'#Region Public methods
	
	'#Region PreSetp variables
	Field _floatTemp1:Float = 0
	Field _vectorTemp1:Vector2 = Vector2.Zero()
	Field _vectorTemp2:Vector2 = Vector2.Zero()
	Field _vectorTemp3:Vector2 = Vector2.Zero()
	Field _vectorTemp4:Vector2 = Vector2.Zero()
	Field _vectorTemp5:Vector2 = Vector2.Zero()
	
	Field _K:TMatrix = TMatrix.Identity()
	Field _K1:TMatrix = TMatrix.Identity()
	Field _K2:TMatrix = TMatrix.Identity()
	
	Field _bodyMatrixTemp:TMatrix = TMatrix.Identity()
	Field _bodyInverseMass:Float
	Field _bodyInverseMomentOfInertia:Float
	'#End Region 
	Method PreStep(inversedt:Float)
		If Abs(_jointError) > _breakPoint Then Return
		
		_bodyInverseMass = _body._inverseMass
		_bodyInverseMomentOfInertia = _body._inverseMomentOfInertia
		
		_body.GetBodyMatrixRef(_bodyMatrixTemp)
		Vector2.TransformNormalRef(_localAnchor, _bodyMatrixTemp, _r1)
		
		_K1.M11 = _bodyInverseMass
		_K1.M12 = 0
		_K1.M21 = 0
		_K1.M22 = _bodyInverseMass
		
		_K2.M11 = _bodyInverseMomentOfInertia * _r1.Y * _r1.Y
		_K2.M12 = -_bodyInverseMomentOfInertia * _r1.X * _r1.Y
		_K2.M21 = -_bodyInverseMomentOfInertia * _r1.X * _r1.Y
		_K2.M22 = _bodyInverseMomentOfInertia * _r1.X * _r1.X
		
		' matrix K = K1 + K2 + K3
		TMatrix.AddRef(_K1, _K2, _K)
		
		_K.M11:+_softness
		_K.M12:+_softness
		
		'matrix = matrixInvert2D(K)
		MatrixInvert2D(_K, _matrix)
		
		Vector2.AddVectorsRef(_body._position, _r1, _vectorTemp1)
		Vector2.SubtractVectorsRef(_anchor, _vectorTemp1, _vectorTemp2)
		Vector2.ScaleRef(_vectorTemp2, - _biasFactor * inverseDt, _velocityBias)
		_jointError = _vectorTemp2.Length()
		
		' warm starting
		_vectorTemp1.X = -_accumulatedImpulse.X
		_vectorTemp1.Y = -_accumulatedImpulse.Y
		If _maxImpulse < MathHelper.MaxValueF Then
			Calculator.TruncateRef(_vectorTemp1, _maxImpulse, _vectorTemp1)			
		End If
		_body.ApplyImmediateImpulse(_vectorTemp1)
		_floatTemp1 = Calculator.CrossVV(_r1, _vectorTemp1)
		_body.ApplyAngularImpulse(_floatTemp1)
	End Method

	Field _B:TMatrix = TMatrix.Identity()
	Method MatrixInvert2D(matrix:TMatrix, outInvertedMatrix:TMatrix)
		Local a:Float = matrix.M11
		Local b:Float = matrix.M12
		Local c:Float = matrix.M21
		Local d:Float = matrix.M22
		Local det:Float = a * d - b * c
		Assert det <> 0, "Determinant is equal to Zero in Fixed revolute Joint"
		det = 1.0 / det
		_B.M11 = det * d; _B.M12 = -det * b
		_B.M21 = -det * c; _B.M22 = det * a
		_B.CopyTo(outInvertedMatrix)
	End Method
	
	
	'#Region Update variables
	Field _dv:Vector2 = Vector2.Zero()
	Field _dvBias:Vector2 = Vector2.Zero()
	Field _impulse:Vector2 = Vector2.Zero()
	'#End Region 
	Method Update()
		If Abs(_jointError) > _breakPoint Then Return
		Calculator.CrossFVRef(_body._angularVelocity, _r1, _vectorTemp1)
		Vector2.AddVectorsRef(_body._linearVelocity, _vectorTemp1, _dv)
		_dv.X = -_dv.X
		_dv.Y = -_dv.Y
		
		Vector2.SubtractVectorsRef(_velocityBias, _dv, _vectorTemp1)
		Vector2.ScaleRef(_accumulatedImpulse, _softness, _vectorTemp2)
		Vector2.SubtractVectorsRef(_vectorTemp1, _vectorTemp2, _dvBias)
		
		Vector2.TransformRef(_dvBias, _matrix, _impulse)
		
		_vectorTemp1.X = -_impulse.X
		_vectorTemp1.Y = -_impulse.Y
		If _maxImpulse < MathHelper.MaxValueF Then
			Calculator.TruncateRef(_vectorTemp1, _maxImpulse, _vectorTemp1)			
		End If
		_body.ApplyImmediateImpulse(_vectorTemp1)
		_floatTemp1 = Calculator.CrossVV(_r1, _vectorTemp1)
		_body.ApplyAngularImpulse(_floatTemp1)
		
		Vector2.AddVectorsRef(_accumulatedImpulse, _impulse, _accumulatedImpulse)
		
	End Method

	'#End Region 
End Type
